<?php
/*
  Actions here are very similar to standard meta actions (DateWritten and such) but
  are used in blog environments. Some of them can be set via {{Meta}} but separate
  actions provide cleaner source ({{Meta synopsis=...}} vs. {{Synopsis ...}}).

    {{Related:  my_post, that post, "and, again, a post"}}
    {{Category: Friends > Mark}}         - more common categories come first
    {{Synopsis: Similar to Nutshell but larger description - up to a few sentenses.}}
*/

class Urelated_Root extends Umeta_Root {
  function Execute($format, $params) {
    $relatedTo = array_keys($params);
    $posts = &$format->origDoc->meta['related'];
    $posts = array_merge($posts, $relatedTo);
  }
}

class Ucategory_Root extends Utags_Root {
  public $metaName = 'category';

  function Execute($format, $params) {
    if ($params) {
      $params = array_keys($params);
      $params = explode('>', $params[0]);
    }
    parent::Execute($format, array_flip($params));
  }
}

class Usynopsis_Root extends Uauthor_Root {
  public $metaName = 'synopsis';
}
